#!/usr/bin/env bash
######################################################################
#FILE: .*_unit-test_.*_aborting.sh
#SW-COMPONENT: Tooling
#DESCRIPTION: Generate and execute unit tests of the component
#             Executed by call from execute_unit-tests.py
#COPYRIGHT: (C) 2019 Robert Bosch GmbH
#
#The reproduction, distribution and utilization of this file as
#well as the communication of its contents to others without express
#authorization is prohibited. Offenders will be held liable for the
#payment of damages. All rights reserved in the event of the grant
#of a patent, utility model or design.
######################################################################
set -eu
OUTNAME=`basename "${0%.*}"`.xml
BASEDIR=$(realpath $(dirname "$0"))
WORKSPACEROOT=${BASEDIR}
while [ ! -d ${WORKSPACEROOT}/qnx-sdp ] && [ "${#WORKSPACEROOT}" -gt 0 ]; do
  WORKSPACEROOT=${WORKSPACEROOT%/*}
done
if [ ! -d ${WORKSPACEROOT}/qnx-sdp ] ; then echo "bad workspaceroot: ${WORKSPACEROOT}, exiting";  exit 2; fi
STOPONFAILURE=true

cd ${BASEDIR}/unit_test
. setenv.sh ${WORKSPACEROOT}/qnx-sdp/
cd ..
make
RESULT=$?
cd ./linux/x86_64/o

UTESTS="
atmel_utest
"
set +eu

for UTEST in $UTESTS; do
  ./$UTEST  --gtest_output=xml:$OUTNAME
  RETVAL=$?
  ((RESULT+=$RETVAL))
  if [[ $RETVAL -ne 0 ]] && $STOPONFAILURE ; then exit $RETVAL; fi
done

echo "RESULT: "${RESULT}
exit $RESULT

